  
---

### **Overview of IPsec**

- Defined in **RFC 4301** as the Security Architecture for the Internet Protocol.
- Designed to provide cryptographically based transmission security for IP traffic.
- **Security Services Provided**:
    - Access control.
    - Connectionless integrity.
    - Data origin authentication.
    - Protection against replay attacks.
    - Confidentiality.
    - Limited traffic flow confidentiality.
- Operates at the **network layer**, protecting both IP and upper-layer protocols.

---
![[Pasted image 20250628152948.png]]


### **Key Components of IPsec**

1. **Security Protocols**:
    
    - **Internet Key Exchange (IKE)**: Handles key management.
    - **Authentication Header (AH)**:
        - Provides data integrity, origin authentication, and anti-replay.
        - Does not provide confidentiality (encryption).
    - **Encapsulating Security Payload (ESP)**:
        - Provides confidentiality, integrity, origin authentication, and anti-replay.
        - Preferred over AH in most applications.
2. **Modes of Operation**: Regardless of using ESP or AH, we choose from two modes below: 
    
    - **Transport Mode**:
        - Encrypts only the data portion (payload) of the IP packet.
        - Leaves the original IP header intact.
        - Used when IP packets are routable across the transport network.
    - **Tunnel Mode**:
        - Encrypts the data portion and the IP header.
        - Adds a new IP header for routing across the transport network.
        - Results in packet expansion (approximately 20 bytes).

---

### **IPsec Security Associations (SAs)**

- **Definition**: Describes current traffic protection parameters being applied to specific user traffic flows (algorithms, keys, and traffic specifications).
- **Characteristics**:
    - Both AH and ESP use SAs.
    - Two SAs (one in each direction) are required for bidirectional communication.
    - **IKE's Role**:
        - Establishes and maintains SAs.
        - Creates a secure connection between entities for SA negotiation.

---

### **Internet Key Exchange (IKE)**

- **Purpose**: Establishes shared security policies and authenticated keys for IPsec.
- **Versions**:
    - **IKEv1**: Operates in two phases:
        - **Phase 1**: Establishes a secure, authenticated channel using Diffie-Hellman (DH) key exchange. Can operate in:
            - **Main Mode**: Protects peer identity (such as one using static IP)  but does not support dynamically addressed peers (such as dynamic IP) with PSK authentication.
            - **Aggressive Mode**: Supports PSK authentication for dynamic peers but does not protect peer identity.
        - **Phase 2**: Negotiates IPsec SAs and optionally enables Perfect Forward Secrecy (PFS) for enhanced security.
    - **IKEv2**:
        - Simplifies the SA negotiation process compared to IKEv1.
        - Requires fewer round trips (two for basic exchange).
        - Provides built-in NAT traversal, dead peer detection, and configuration payload.
        - Supports unidirectional authentication methods and better rekeying.

---

### **Encapsulating Security Payload (ESP)**

- **Purpose**: Provides a mix of security services, including:
    - Confidentiality (encryption).
    - Integrity.
    - Origin authentication.
    - Anti-replay protection.
- **Operation**:
    - In **tunnel mode**, ESP encapsulates the entire IP packet and adds a new IP header.
    - Uses IP protocol 50 (no port information like TCP/UDP).
- **NAT Traversal (NAT-T)**:
    - Allows ESP traffic to pass through devices performing Port Address Translation (PAT).
    - Encapsulates ESP packets in a UDP header (using port 4500) when NAT is detected.
    - Steps:
        1. Detects if both VPN endpoints support NAT-T.
        2. Identifies NAT devices along the transmission path.
        3. Encapsulates ESP in UDP if NAT exists.

---

### **IKEv1 vs. IKEv2**

|**Feature**|**IKEv1**|**IKEv2**|
|---|---|---|
|**Round Trips**|Requires multiple (up to 9)|Requires only 2 for basic exchange|
|**Built-in Features**|Lacks built-in NAT-T, DPD, and EAP|Includes NAT-T, DPD, and EAP|
|**Message Compatibility**|Compatible with IKEv1|Not compatible with IKEv1|
|**Rekeying and Collision Handling**|Limited|Improved|
|**Authentication Methods**|Symmetric (both sides use the same method)|Asymmetric (e.g., PSKs and certificates)|
|**Simplification**|Complex SA negotiation|Simplified SA negotiation|

---

### **Advantages of Using IPsec**

- **Scalability**: Supports multiple paths between hosts, gateways, and networks.
- **Flexibility**: AH and ESP can be used independently or together.
- **Security at the Network Layer**: Protects both IP and upper-layer protocols.
- **Interoperability**: Supports a wide range of devices and environments.

---

### **Conclusion**

IPsec is a versatile and robust protocol suite that provides essential security services for IP traffic. Its components, such as IKE, AH, and ESP, work together to ensure data confidentiality, integrity, and authenticity. With advancements in IKEv2 and features like NAT traversal, IPsec remains a critical technology for securing communications in modern networks.